<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\User;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function userFromOpenid(array $parm = [])
    {
        parent::init('OfficialAccount\UserInfo');
        $openid = $parm['openid'] ?? '';
        if (! $openid) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('openid参数错误');
        }
        $parm = [
            'openid' => $openid,
        ];
        return parent::http_run($parm);
    }

    public function userList(array $parm = [])
    {
        parent::init('OfficialAccount\UserList');
        $page = $parm['page'] ?? 1;
        $perPage = $parm['perPage'] ?? 100;
        $parm = [
            'page' => $page,
            'perPage' => $perPage,
        ];
        return parent::http_run($parm);
    }

    public function userFromCode($parm)
    {
        parent::init('OfficialAccount\AuthDecode');
        $code = $parm['code'] ?? '';
        if (! $code) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('code参数错误');
        }
        $parm = [
            'code' => $code,
        ];
        return $this->http_run($parm);
    }
}
