<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount;

use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Application.
 *
 * @property \Tpmission\Openwechat\OfficialAccount\Auth\Client $auth
 * @property \Tpmission\Openwechat\OfficialAccount\JsSdk\Client $jsSdk
 * @property \Tpmission\Openwechat\OfficialAccount\Message\Client $message
 * @property \Tpmission\Openwechat\OfficialAccount\User\Client $user
 * @property \Tpmission\Openwechat\OfficialAccount\Server\Client $server
 * @property \Tpmission\Openwechat\OfficialAccount\Qrcode\Client $qrcode
 * @property \Tpmission\Openwechat\OfficialAccount\TemplateMsg\Client $templateMsg
 * @property \Tpmission\Openwechat\OfficialAccount\Callback\Client $callback
 */
class Application extends SdkContainer
{
    /**
     * @var array
     */
    protected $providers = [
        Auth\ServiceProvider::class,
        JsSdk\ServiceProvider::class,
        Message\ServiceProvider::class,
        MsgPreg\ServiceProvider::class,
        User\ServiceProvider::class,
        Server\ServiceProvider::class,
        Qrcode\ServiceProvider::class,
        TemplateMsg\ServiceProvider::class,
        Callback\ServiceProvider::class,
    ];
}
