<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\MiniProgram\CheckText;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    protected $http_method = 'post';

    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function check(array $parm = [])
    {
        parent::init('MiniProgram\CheckText');
        $content = $parm['content'] ?? '';
        $openid = $parm['openid'] ?? '';
        $scene = $parm['scene'] ?? 2;

        $parm = [
            'content' => $content,
            'openid'=> $openid,
            'scene' => $scene,
        ];
        return parent::http_run($parm);
    }
}
