<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat;

/**
 * Class Factory.
 * @method static \Tpmission\Openwechat\OfficialAccount\Application       OfficialAccount(array $config)
 * @method static \Tpmission\Openwechat\MiniProgram\Application       miniProgram(array $config)
 * @method static \Tpmission\Openwechat\Web\Application       web(array $config)
 */
class Factory
{
    protected static $default_version = 'V2';

    /**
     * Dynamically pass methods to the application.
     *
     * @param string $name
     * @param array $arguments
     *
     * @return mixed
     */
    public static function __callStatic($name, $arguments)
    {
        return self::make($name, ...$arguments);
    }

    /**
     * @param string $name
     *
     * @return \Tpmission\Openwechat\Base\BaseApplication
     */
    public static function make($name, array $config)
    {
        if ($name === 'debug') {
            return [date('Y-m-d H:i:s'),];
        }
        $version_str = '';
        if (isset($config['sdk_version']) && $config['sdk_version'] && $config['sdk_version'] !== self::$default_version) {
            $version_str = $config['sdk_version'];
        }
        $name .= $version_str;
        $name = ucfirst($name);
        $application = "\\Tpmission\\Openwechat\\{$name}\\Application";
        return new $application($config);
    }
}
