<h1 align="center"> openwechat </h1>

<p align="center"> a sdk to use easywechat.</p>


## 安装

```shell

编辑项目 composer.json 对应参数（如项目无使用composer请执行composer init网上查阅相关文档安装composer）
{
   .....
   "require": {
      "tpmission/openwechat": "^0.1.6"
   },
   "repositories": [
        {
            "type":"composer",
            "url":"https://packages.tpmission.com/"
        }
    ]
}
$ composer require tpmission/openwechat
  
至此安装完毕
```
## 配置
```
使用拓展前，请联系我们获取授权使用账号以及token
```

## 使用实例

```
下面以原生php，发起授权页面auth.php为例：  
  
<?php 
require __DIR__ .'/vendor/autoload.php';  
  
use Tpmission\Openwechat\Factory;
  
$account = "test"; //联系我们获得
$token = "test_token"  //联系我们获得
  
try{
  //这里以公众号为例
  $app = Factory::OfficialAccount([
      'acc'=> $acc,
      'appid' => 'wx977535b66702047d', //要使用的公众号或小程序appid,在微信公众平台获取。前提已经授权过我们第三方平台
      'token' => $token,
      'response_type' => 'array', //返回数据格式，默认json，这里选择返回数组
  ]);
  //获取授权连接
  $redirect_data = $app->auth->create([
          'state' => xxx, //自定义参数授权完会按定义值返回，可用户区分不同场景授权
          'scope' => 'snsapi_userinfo', //可选值 snsapi_userinfo snsapi_base前者需要用户确认授权，能获取比较用户信息
          'redirect_uri' => 'https://xxx.com',//自定义网站回调地址，授权完用户数据会以get方式返回到回调地址中。
  ]);
  if($redirect_data['code'] == 200 && $redirect_data['data']['errorCode'] == 0){
     $redirect_url = $redirect_data['data']['data']['auth_url'];
     header("Location:{$redirect_url}"); //到此提交授权业务结束
  }else{
     //var_dump($redirect_data);
     throw new \Exception("请求失败");
  }
}catch (\Exception $e){
   $err = $e->getMessage();
   echo $err;
}
  
?>    
  
  
//接收授权信息网站回调页面auth_callback.php  
<?php 
require __DIR__ .'/vendor/autoload.php';  
  
use Tpmission\Openwechat\Factory;
  
    $auth_data = $_GET;
    if($auth_data['auth_status'] == 'success'){
       //授权成功
       $code = $auth_data['code'];
       $state = $auth_data['state'];
       //通过code码获取用户信息
       $account = "test"; //联系我们获得
       $token = "test_token"  //联系我们获得
       $time_stamp = date('Y-m-d H:i:s');
         
       try{
         $app = Factory::OfficialAccount([
             'acc'=> $acc,
             'appid' => 'wx977535b66702047d', //要使用的公众号或小程序appid,在微信公众平台获取。前提已经授权过我们第三方平台
             'token' => $token,
             'response_type' => 'array',
         ]);
         $user_data = $app->user->userFromCode([
             'code' => $code //返回的code参数
         ]);
         if($user_data['code'] == 200 && $user_data['data']['errorCode'] == 0){
            $user = $user_data['data']['data'];
            var_dump($user);
         }else{
            throw new \Exception("获取用户数据失败");
         }
       }catch (\Exception $e){
          $err = $e->getMessage();
          echo $err;
       }
    }else{
       //授权失败
    }
    
?>
  
```

## API
```
 全局接口返回格式
 {
    code : 200, //http请求状态码，200表示请求接口成功
    msg : "", //状态码描述
    data : {  //返回数据
       errorCode:0, //接口处理状态码，0为成功，其他为失败
       errorMsg:'', //接口处理状态描述
       data:[  //接口处理返回结果
       ]
    }
 }
 
 这里以已经获取xx实例为例，获取实例具体方法可查阅上方例子
```
| 序号 | 接口名称 | 接口类型 | 描述                                              |
| ------ | -------- | ------ | ------------------------------------------------- |
|  1.0.0  |  [获取授权接口](#1.0.0)      | 公众号 | |
|  1.0.1  |  [根据code码获取用户信息](#1.0.1)      | 公众号 | |
|  1.0.2  |  [根据openid获取用户信息](#1.0.2)      | 公众号 | |
|  1.0.3  |  [获取公众号用户关注列表](#1.0.3)      | 公众号 | |
|  1.0.4  |  [获取 jssdk 注册参数](#1.0.4)      | 公众号 | |
|  1.0.5  |  [设置公众号事件回调地址(弃用)](#1.0.5)      | 公众号 | |
|  1.0.6  |  [设置消息模板](#1.0.6)      | 公众号 | |
|  1.0.7  |  [编辑消息模板](#1.0.7)      | 公众号 | |
|  1.0.8  |  [删除消息模板](#1.0.8)      | 公众号 | |
|  1.0.9  |  [设置匹配模板](#1.0.9)      | 公众号 | |
|  1.1.0  |  [编辑匹配模板](#1.1.0)      | 公众号 | |
|  1.1.1  |  [删除匹配模板](#1.1.1)      | 公众号 | |
|  1.1.2  |  [获取参数二维码](#1.1.2)      | 公众号 | |
|  1.1.3  |  [设置微信事件推送地址](#1.1.3)      | 公众号 | |
|  1.1.4  |  [发送模板消息](#1.1.4)      | 公众号 | |
|  2.0.1  |  [小程序登录接口](#2.0.1)      | 小程序 | |
|  2.0.2  |  [获取用户手机号码](#2.0.2)      | 小程序 | |
### 一、 获取公众号实例：
```angular2html
use Tpmission\Openwechat\Factory;

//同一主体中台账号和token都是同一个，通过传递不同的appid操作对应公众号
$acc = 'xxx'; 
$token = 'xxxxx';

/*@var \Tpmission\Openwechat\OfficialAccount\Application */
$app = Factory::OfficialAccount([
    'acc' => $acc,
    'appid' => 'wx977535b66702047d', 
    'token' => $token,
    'response_type' => 'array',
]);
```
### 二、获取小程序实例：
```angular2html
use Tpmission\Openwechat\Factory;

//同一主体中台账号和token都是同一个，通过传递不同的appid操作对应公众号
$acc = 'xxx'; 
$token = 'xxxxx';

/*@var \Tpmission\Openwechat\MiniProgram\Application */
$app = Factory::miniProgram([
    'acc' => $acc,
    'appid' => 'wx977535b66702047d', 
    'token' => $token,
    'response_type' => 'array',
]);
```
### 三、公众号接口

#### <a id="1.0.0">1.0.0 获取授权接口</a>

1、接口参数：

| 参数名 | 是否必须 | 描述 |
| :---- | :----  | :----  |
| state  | 否 | 授权玩会原封不动传递回来的参数，可用于区分不同的授权场景 |
| scope | 是 | 授权方式可选择snsapi_userinfo，snsapi_base |
| redirect_uri | 是 | 授权回调地址 |

2、示例
```
$res = $app->auth->create([
   'state' => "自定义参数",
   'scope' => 'snsapi_userinfo',//授权参数
   'redirect_uri' => 'https://wechatclient.chudianchengzhang.com/sdkTest2/authBack',
]);
```

3、成功返回data参数

```
{
 "auth_url":"https://open.weixin.qq.com/connect/oauth2/authorize..." //用户跳转授权链接
}
```

#### <a id="1.0.1">1.0.1 根据code码获取用户信息</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| code   | 是       | 授权定义回调页面，我们会通过get方式传递code参数值 |

2、 示例

```php
$res = $app->user->userFromCode([
    'code' => $code,
]);
```

3、成功返回data参数（注意以下是以1.0接口授权时参数scope为snsapi_userinfo返回数据为例）

```json
{   
  "openid": "OPENID",
  "nickname": NICKNAME,
  "sex": 1,
  "province":"PROVINCE",
  "city":"CITY",
  "country":"COUNTRY",
  "headimgurl":"https://thirdwx.qlogo.cn/mmopen/g3MonUZtNHkdmzicIlibx6iaFqAc56vxLSUfpb6n5WKSYVY0ChQKkiaJSgQ1dZuTOgvLLrhJbERQQ4eMsv84eavHiaiceqxibJxCfHe/46",
  "privilege":[ "PRIVILEGE1", "PRIVILEGE2"     ],
  "unionid": "o6_bmasdasdsad6_2sgVt7hMZOPfL"
}
```

#### <a id="1.0.2">1.0.2  根据openid获取用户信息</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| openid   | 是       | 要获取信息用户的openid，(以下结果基于用户已经关注公众号的前提下) |

2、 示例

```php
$res = $app->user->userFromOpenid([
    'openid' => $openid
]);
```

3、成功返回data参数

```json
{
    "subscribe":1,
    "openid":"oh2QQxCtdFEDNfEzkoXwTxSRxwhs
    nickname":"天生桥",
    "sex":1,
    "language":"zh_CN",
    "city":"广州",
    "province":"广东",
    "country":"中国",
  "headimgurl":"http:\/\/thirdwx.qlogo.cn\/mmopen\/wzJhLVPsrd0DlGOib1Raom8GiaHDOjKgS9uib2ia1TLSp96LvSO84nOCibhMrWQ9k7X4Thicuhph1E86urJX8OQocZPQ\/132",    
    "subscribe_time":1619601577,
    "unionid":"oPUUywObz7_zURIg00H4Oa7L84AQ", //前提公众号绑定同一开放平台
    "remark":"",
    "groupid":0,
    "tagid_list":[],
    "subscribe_scene":"ADD_SCENE_SEARCH",
    "qr_scene":0,
    "qr_scene_str":""
}
```
#### <a id="1.0.3">1.0.3 获取公众号用户关注列表</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| page | 否 | 获取页数，不传默认1                     |
| perPage | 否 | 每页获取条数，不传默认每页获取100条数据 |

2、 示例

```php
$res = $app->user->userList([
    page => 1,
    perPage => 100
]);
```

3、成功返回data参数

```json
{
    "current_page":1,
    "data":[
        {"city":"广州","country":"中国","groupid":0,"headimgurl":"http:\/\/thirdwx.qlogo.cn\/mmopen\/wzJhLVPsrd0DlGOib1Raom8GiaHDOjKgS9uib2ia1TLSp96LvSO84nOCibhMrWQ9k7X4Thicuhph1E86urJX8OQocZPQ\/132","nickname":"天生桥","openid":"oh2QQxCtdFEDNfEzkoXwTxSRxwhs","province":"广东","qrScene":"0","qrSceneStr":"","sex":1,"subscribe":1,"subscribeScene":"ADD_SCENE_SEARCH","subscribeTime":"2021-04-28 17:19:37","tagidList":"[]"},
        {....}
    ],
    "total":5
}
```

#### <a id="1.0.4">1.0.4 获取 jssdk 注册参数</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| apis | 是       | 要使用的api接口，以数组方式传递，例如["updateTimelineShareData","updateAppMessageShareData"] |
| debug | 否 | 是否开启debug调试模式，传布尔值，可选择true，false，默认false。 |
| url | 是 | 当前页面url |

2、 示例

```php
$res = $app->jsSdk->create([
    'apis'=> ["updateTimelineShareData","updateAppMessageShareData"],
    'debug' => false,
    'url' => 'http://xxx'
]);
```

3、成功返回data参数

```json
{
    "debug":false,
    "beta":false,
    "jsApiList":["updateTimelineShareData","updateAppMessageShareData"],
    "openTagList":[],
  "appId":"xxxx",
  "nonceStr":"zULC2Lc3ai",
  "timestamp":1620871627,
  "url":"http://xxx",
    "signature":"6b58df3565f0f6d300753dcbd94a4cc76a091e7b"
}
```
#### <a id="1.0.5">1.0.5 设置公众号事件回调地址</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| callback_uri | 是  | 事件回调地址 |

2、 示例

```php
$res = $app->server->callback([
    'callback_uri' => 'http://xxxxx'，
]);
```

如需回复消息，请按以下个格式返回json数据

```
{
   'returnMsgType' => 'text',//可选值news,text,img,voice,video分别代表图文消息，文本消息，图片消息，语音消息，视频消息
   'returnMsgData' => {
      ......
      //消息主体，根据returnMsgType值返回对应消息主体数据。
   }
}

returnMsgData具体参数：

1、文本消息（returnMsgType值为text）
{
  'content' : '消息文本内容', 
}

2、图文消息（returnMsgType值为news）
{
   'title' : 'xxx',//图文标题
   'description' : 'xxxx', //图文描述
   'url' : 'http://xxx', //图文点击跳转地址
   'image' : 'http://xxx', //图文显示图片
}

3、图片消息（returnMsgType值为img）
{
   media_id:'xxx'//图片素材id
}

4、语音消息（returnMsgType值为voice）
{
   media_id:'xxx'//语音素材id
}

5、视频消息（returnMsgType值为voide）
{
  'title' : "视频标题",
  'description' : "视频描述",
  'media_id': '视频素材id',
  'thumb_media_id' : '视频封面图片素材id，可选'
}
```

#### <a id="1.0.6">1.0.6 设置消息模板</a>

1、接口参数（如果不想处理公众号消息/事件，可以通过本接口和1.7接口，设置消息由我们回复）

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| msg_type | 是       | 可选值news,text,img,voice,video分别代表图文消息，文本消息，图片消息，语音消息，视频消息 |
| msg_data | 是 | 消息主体，以数组格式传递，具体值参考下面 |

```
msg_data具体参数：

1、文本消息（msg_type值为text）
[
  'content' => '消息文本内容', 
]

2、图文消息（msg_type值为news）
[
   'title' => 'xxx',//图文标题
   'description' => 'xxxx', //图文描述
   'url' => 'http://xxx', //图文点击跳转地址
   'image' => 'http://xxx', //图文显示图片
]

3、图片消息（msg_type值为img）
[
   media_id => 'xxx'//图片素材id
]

4、语音消息（msg_type值为voice）
[
   media_id => 'xxx'//语音素材id
]

5、视频消息（msg_type值为voide）
[
  'title' => "视频标题",
  'description' => "视频描述",
  'media_id' => '视频素材id',
  'thumb_media_id' => '视频封面图片素材id，可选'
]
```



2、 示例

```php
$res = $app->message->create([
    'msg_type' => 'news',
    'msg_data' => [
       'title' => '测试图文消息标题',
       'description' => '测试图文消息描述',
       'image' => 'https://www.baidu.com/img/PCtm_d9c8750bed0b3c7d089fa7d55720d6cf.png',
       'url' => 'https://www.baidu.com',
     ],
]);
```

3、成功返回data参数

```json
{   
  'msg_id' : 9, //消息id 编辑时可用
  'msg_type' : 'news'
}
```

#### <a id="1.0.7">1.0.7 编辑消息模板</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| msg_type | 是       | 可选值news,text,img,voice,video分别代表图文消息，文本消息，图片消息，语音消息，视频消息 |
| msg_data | 是 | 消息主体，以数组格式传递，具体值参考1.6接口解释 |
| msg_id | 是 | 消息id |


2、 示例

```php
$res = $app->message->create([
    'msg_type' => 'news',
    'msg_id' => 9,
    'msg_data' => [
       'title' => '测试图文消息标题',
       'description' => '测试图文消息描述',
       'image' => 'https://www.baidu.com/img/PCtm_d9c8750bed0b3c7d089fa7d55720d6cf.png',
       'url' => 'https://www.baidu.com',
     ],
]);
```

3、成功返回data参数

```json
{   
  'msg_id' : 9, //消息id
  'msg_type' : 'news'
}
```
#### <a id="1.0.8">1.0.8 删除消息模板</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| msg_id   | 是       | 消息id |
| msg_type | 是 | 对应消息id的消息类型，可选值news,text,img,voice,video分别代表图文消息，文本消息，图片消息，语音消息，视频消息 |

2、 示例

```php
$res = $app->message->delete([
    'msg_id' : 9, //消息id
    'msg_type' : 'news'
]);
```
#### <a id="1.0.9">1.0.9 设置匹配模板</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| msg_type | 是       | 消息类型，可选值news,text,img,voice,video分别代表图文消息，文本消息，图片消息，语音消息，视频消息 |
| msg_id | 是 | 消息id |
| preg_type | 是 | 匹配类型可选值，text、video、voice、img、shortvideo、scene、subscribe分别表示：用户在公众号发送文本消息，发送视频消息，发送语音消息，发送图片消息，发送短视频消息，用户扫描参数二维码消息，用户关注公众号消息 |
| preg_content | 否 | preg_type为text、scene时必须传递，分别匹配用户发送的内容和参数二维码参数值内容 |
| preg_method | 否 | preg_type为text时必须传递，可选择EQUAL,LIKE分别代表全等匹配，模糊匹配 |

2、 示例

```php
$res = $app->msgPreg->edit([
    'msg_type' => 'news',
    'preg_type' => 'text',
    'preg_content' => '测试t',
    'msg_id' => 9,
    'preg_method' => 'LIKE'
]);
```

3、成功返回data参数

```json
{   
  preg_id = 10//编辑时可用
}
```

#### <a id="1.1.0">1.1.0 编辑匹配模板</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| preg_id | 是 | 匹配模板id |
| msg_type | 是       | 消息类型，可选值news,text,img,voice,video分别代表图文消息，文本消息，图片消息，语音消息，视频消息 |
| msg_id | 是 | 消息id |
| preg_type | 是 | 匹配类型可选值，text、video、voice、img、shortvideo、scene、subscribe分别表示：用户在公众号发送文本消息，发送视频消息，发送语音消息，发送图片消息，发送短视频消息，用户扫描参数二维码消息，用户关注公众号消息 |
| preg_content | 否 | preg_type为text、scene时必须传递，分别匹配用户发送的内容和参数二维码参数值内容 |
| preg_method | 否 | preg_type为text时必须传递，可选择EQUAL,LIKE分别代表全等匹配，模糊匹配 |

2、 示例

```php
$res = $app->msgPreg->create([
    'preg_id' => 9,
    'msg_type' => 'news',
    'preg_type' => 'text',
    'preg_content' => '测试t',
    'msg_id' => 9,
    'preg_method' => 'LIKE'
]);
```

#### <a id="1.1.1">1.1.1 删除匹配模板</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| preg_id   | 是       | 匹配模板id |


2、 示例

```
$res = $app->msgPreg->delete([
    'preg_id' : 10
]);
```

#### <a id="1.1.2">1.1.2 获取参数二维码</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| qrcodeType   | 是       | 参数二维码类型，可选值forever, temporary分别代表永久和临时参数二维码 |
| scene   | 是       | 参数二维码参数 |
| expireSeconds   | 否       | 参数二维码有效期，qrcodeType为temporary时必传 |


2、 示例

```
$res = $app->qrcode->created([
    'qrcodeType' => 'forever',
    'scene' => 'test666',
    'expireSeconds' => 0,
]);
```

#### <a id="1.1.3">1.1.3 设置微信事件推送地址</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| callback_uri   | 是       | 推送接收地址，中台会将微信推送数据格式化后post到该地址上，单次事件在该地址返回'success'字符串前，最多会post 6次。 |


2、 示例

```
$res = $app->callback->created([
    'callback_uri' => 'https://www.baidu.com',
]);
```

#### <a id="1.1.4">1.1.4 发送模板消息</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| openid   | 是       | 接收模板消息用户openid |
| template_id   | 是       | 公众号设置好的模板id |
| miniprogram   | 否       | 跳转小程序参数，没有传空数组 |
| url   | 是       | 跳转网页地址，设置小程序优先跳转小程序 |
| data   | 是       | 模板消息参数数组格式 |


2、 示例

```
$res =  $app->templateMsg->create([
            'openid' => 'xxxxxx',
            'data' => [
                'first' => 'xxxxxxxxxx',//使用默认字体颜色
                'keyword1' => 'xxxxxxxxxxx',//使用默认字体颜色
                'keyword2' => [//指定字体颜色
                   'value' => 'xxxx',
                   'color' => '#173177'
                ],
                'keyword3' => 'xxxx',
                'keyword4' => 'xxxxxxx',
                'remark' => '感谢您的购买！',
            ],
            'template_id' => $templateId,
            'url' => $this->url,
            'miniprogram' => [
                'appid' => 'xxx', //小程序appid
                'pagepath' => 'xxxx' //小程序页面地址
            ]
]);
```

### 四、小程序接口


#### <a id="2.0.1">2.0.1 小程序登录接口</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| code   | 是       | 用户同意授权获取的code参数 |

2、 示例

```
$res =  $app->auth->create([
    'code' => 'xxxxxx'
]);
```

#### <a id="2.0.2">2.0.2 获取用户手机号码</a>

1、接口参数

| 参数名 | 是否必须 | 描述                                              |
| ------ | -------- | ------------------------------------------------- |
| session_key   | 是       | 登录接口返回session_key |
| iv   | 是       | 用户同意授权获取的iv参数 |
| encryptedData   | 是       | 用户同意授权获取的encryptedData参数 |

2、 示例

```
$res =  $app->auth->create([
    'session_key' => 'xxxxxx'
    'iv' => 'xxxxxx',
    'encryptedData' => 'xxxxxx'
]);
```



