<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\MiniProgram\Qrcode;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    protected $http_method = 'post';

    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function create(array $parm = [])
    {
        parent::init('MiniProgram\Qrcode');
        $path = $parm['path'] ?? '';
        $width = $parm['width'] ?? '';
        $auto_color = $parm['auto_color'] ?? '';
        $line_color = $parm['line_color'] ?? [];

        $parm = [
            'path' => $path,
            'width' => $width,
            'auto_color' => $auto_color,
            'line_color' => $line_color,
        ];
        return parent::http_run($parm);
    }
}
