<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\MiniProgram;

use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Application.
 *
 * @property \Tpmission\Openwechat\MiniProgram\Auth\Client $auth
 * @property \Tpmission\Openwechat\MiniProgram\GetPhoneNumber\Client $getPhoneNumber
 * @property \Tpmission\Openwechat\MiniProgram\GetPhone\Client $getPhone
 * @property \Tpmission\Openwechat\MiniProgram\CheckText\Client $checkText
 * @property \Tpmission\Openwechat\MiniProgram\CheckMedia\Client $checkMedia
 * @property \Tpmission\Openwechat\MiniProgram\Qrcode\Client $qrcode
 */
class Application extends SdkContainer
{
    /**
     * @var array
     */
    protected $providers = [
        Auth\ServiceProvider::class,
        GetPhoneNumber\ServiceProvider::class,
        GetPhone\ServiceProvider::class,
        CheckText\ServiceProvider::class,
        CheckMedia\ServiceProvider::class,
        Qrcode\ServiceProvider::class,
    ];
}
