<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\Common;

use Pimple\Container;

class SdkContainer extends Container
{
    /**
     * @var array
     */
    protected $providers = [];

    /**
     * @var array
     */
    protected $config = [];

    protected $api;

    public function __construct(array $config = [], array $prepends = [], string $api = '')
    {
        $this->config = $config;
        parent::__construct($prepends);

        $this->api = $api;

        $this->registerProviders($this->getProviders());
    }

    public function __get($api)
    {
        return $this->offsetGet($api);
    }

    public function __set($api, $value)
    {
        $this->offsetSet($api, $value);
    }

    public function getProviders()
    {
        return $this->providers;
    }

    public function registerProviders($providers)
    {
        foreach ($providers as $provider) {
            parent::register(new $provider());
        }
    }

    /**
     * @return array
     */
    public function getConfig()
    {
        return $this->config;
    }
}
