<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\Server;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    protected $http_method = 'post';

    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function callback(array $parm = [])
    {
        parent::init('OfficialAccount\Callback');
        $callback_uri = $parm['callback_uri'] ?? '';

        if (! $callback_uri) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('callback_uri参数错误');
        }
        $parm = [
            'callback_uri' => $parm['callback_uri'],
        ];
        return parent::http_run($parm);
    }
}
