<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\Auth;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    protected $http_method = 'post';

    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function create(array $parm = [])
    {
        parent::init('OfficialAccount\Auth');
        $scope = $parm['scope'] ?? 'snsapi_base';
        $state = $parm['state'] ?? '';
        $redirect_uri = $parm['redirect_uri'] ?? '';
        if (! in_array($scope, ['snsapi_userinfo', 'snsapi_base'])) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('scope参数错误');
        }
        if (! $redirect_uri) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('redirect_uri参数错误');
        }
        $check_state_str = strpos($redirect_uri, '?') === false ?
            $redirect_uri . '?state=' . $state :
            $redirect_uri . '&state=' . $state;
        $check_state_str = urlencode($check_state_str);
        if (strlen($check_state_str) > 128) {
            if ($state) {
                throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('state参数太长了');
            }
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('回调地址太长了，请简化url');
        }
        $parm = [
            'scope' => $scope,
            'state' => $state,
            'redirect_uri' => $parm['redirect_uri'],
        ];
        return parent::http_run($parm);
    }
}
