<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\MiniProgram\GetPhoneNumber;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    protected $http_method = 'post';

    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function create(array $parm = [])
    {
        parent::init('MiniProgram\GetPhoneNumber');
        $session_key = $parm['session_key'] ?? '';
        $iv = $parm['iv'] ?? '';
        $encryptedData = $parm['encryptedData'] ?? '';

        $parm = [
            'session_key' => $session_key,
            'iv' => $iv,
            'encryptedData' => $encryptedData,
        ];
        return parent::http_run($parm);
    }
}
