<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\Message;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function delete(array $parm = [])
    {
        parent::init('OfficialAccount\MsgDelete');

        $msg_type = $parm['msg_type'] ?? '';
        $msg_id = $parm['msg_id'] ?? 0;

        if (! in_array($msg_type, $this->msg_types)) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('msg_type参数错误');
        }

        if (! $msg_id) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('请选择要删除的消息');
        }

        $parm = [
            'msg_type' => $msg_type,
            'msg_id' => $msg_id,
        ];
        return parent::http_run($parm);
    }

    public function edit(array $parm = [])
    {
        parent::init('OfficialAccount\MsgEdit');

        $msg_type = $parm['msg_type'] ?? '';
        $msg_data = $parm['msg_data'] ?? [];
        $msg_id = $parm['msg_id'] ?? 0;
        if (! in_array($msg_type, $this->msg_types)) {
            $this->Errs('msg_type参数错误');
        }

        if (! $msg_id) {
            $this->Errs('请选择要编辑的消息');
        }

        switch ($msg_type) {
            case 'text':
                $content = $msg_data['content'] ?? '';
                if (! $content) {
                    $this->Errs('content参数不能为空');
                }
                $msg_data = [
                    'content' => $content,
                ];
                break;
            case 'news':
                $title = $msg_data['title'] ?? '';
                $description = $msg_data['description'] ?? '';
                $image = $msg_data['image'] ?? '';
                $url = $msg_data['url'] ?? '';
                if (! $title) {
                    $this->Errs('图文标题不能为空');
                }
                if (! $description) {
                    $this->Errs('图文描述不能为空');
                }
                if (! $image) {
                    $this->Errs('图文图片不能为空');
                }
                if (! $url) {
                    $this->Errs('图文链接不能为空');
                }
                $msg_data = [
                    'title' => $title,
                    'description' => $description,
                    'image' => $image,
                    'url' => $url,
                ];
                break;
            case 'img':
                $media_id = $msg_data['media_id'] ?? '';
                if (! $media_id) {
                    $this->Errs('media_id参数不能为空');
                }
                $msg_data = [
                    'media_id' => $media_id,
                ];
                break;
            case 'voice':
                $media_id = $msg_data['media_id'] ?? '';
                if (! $media_id) {
                    $this->Errs('media_id参数不能为空');
                }
                $msg_data = [
                    'media_id' => $media_id,
                ];
                break;
            case 'video':
                $title = $msg_data['title'] ?? '';
                $description = $msg_type['description'] ?? '';
                $media_id = $msg_data['media_id'] ?? '';
                $thumb_media_id = $msg_data['thumb_media_id'] ?? '';
                if (! $title) {
                    $this->Errs('视频标题不能为空');
                }
                if (! $description) {
                    $this->Errs('视频描述不能为空');
                }
                if (! $media_id) {
                    $this->Errs('视频资源id不能为空');
                }
                $msg_data = [
                    'title' => $title,
                    'description' => $description,
                    'media_id' => $media_id,
                    'thumb_media_id' => $thumb_media_id,
                ];
                break;
        }

        $parm = [
            'msg_type' => $msg_type,
            'msg_id' => $msg_id,
            'msg_data' => $msg_data,
        ];
        return parent::http_run($parm);
    }

    public function create(array $parm = [])
    {
        parent::init('OfficialAccount\MsgEdit');

        $msg_type = $parm['msg_type'] ?? '';
        $msg_data = $parm['msg_data'] ?? [];

        if (! in_array($msg_type, $this->msg_types)) {
            $this->Errs('msg_type参数错误');
        }

        switch ($msg_type) {
            case 'text':
                $content = $msg_data['content'] ?? '';
                if (! $content) {
                    $this->Errs('content参数不能为空');
                }
                $msg_data = [
                    'content' => $content,
                ];
                break;
            case 'news':
                $title = $msg_data['title'] ?? '';
                $description = $msg_data['description'] ?? '';
                $image = $msg_data['image'] ?? '';
                $url = $msg_data['url'] ?? '';
                if (! $title) {
                    $this->Errs('图文标题不能为空');
                }
                if (! $description) {
                    $this->Errs('图文描述不能为空');
                }
                if (! $image) {
                    $this->Errs('图文图片不能为空');
                }
                if (! $url) {
                    $this->Errs('图文链接不能为空');
                }
                $msg_data = [
                    'title' => $title,
                    'description' => $description,
                    'image' => $image,
                    'url' => $url,
                ];
                break;
            case 'img':
                $media_id = $msg_data['media_id'] ?? '';
                if (! $media_id) {
                    $this->Errs('media_id参数不能为空');
                }
                $msg_data = [
                    'media_id' => $media_id,
                ];
                break;
            case 'voice':
                $media_id = $msg_data['media_id'] ?? '';
                if (! $media_id) {
                    $this->Errs('media_id参数不能为空');
                }
                $msg_data = [
                    'media_id' => $media_id,
                ];
                break;
            case 'video':
                $title = $msg_data['title'] ?? '';
                $description = $msg_type['description'] ?? '';
                $media_id = $msg_data['media_id'] ?? '';
                $thumb_media_id = $msg_data['thumb_media_id'] ?? '';
                if (! $title) {
                    $this->Errs('视频标题不能为空');
                }
                if (! $description) {
                    $this->Errs('视频描述不能为空');
                }
                if (! $media_id) {
                    $this->Errs('视频资源id不能为空');
                }
                $msg_data = [
                    'title' => $title,
                    'description' => $description,
                    'media_id' => $media_id,
                    'thumb_media_id' => $thumb_media_id,
                ];
                break;
        }

        $parm = [
            'msg_type' => $msg_type,
            'msg_data' => $msg_data,
        ];
        return parent::http_run($parm);
    }
}
