<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\JsSdk;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function create(array $parm = [])
    {
        parent::init('OfficialAccount\JsSdk');
        $apis = $parm['apis'] ?? [];
        $debug = $parm['debug'] ?? false;
        $url = $parm['url'] ?? '';
        $openTagList = $parm['openTagList'] ?? '';
        $parm = [
            'apis' => $apis,
            'debug' => $debug,
            'url' => $url,
        ];
        return parent::http_run($parm);
    }
}
