<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\TemplateMsg;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function create(array $parm = [])
    {
        parent::init('OfficialAccount\TemplateMsg');
        $openid = $parm['openid'] ?? '';
        $template_id = $parm['template_id'] ?? '';
        $miniprogram = $parm['miniprogram'] ?? [];
        $data = $parm['data'] ?? [];
        $url = $parm['url'] ?? '';

        if (! $openid) {
            $this->Errs('请添加接收人');
        }
        if (! $template_id) {
            $this->Errs('请选择模板');
        }
        if (! is_array($miniprogram)) {
            $this->Errs('请正确配置小程序信息');
        }
        if (! is_array($data)) {
            $this->Errs('请正确配置模板消息内容');
        }

        if (empty($miniprogram) && $url === '') {
            $this->Errs('请配置跳转地址');
        }
        $parm = [
            'openid' => $openid,
            'template_id' => $template_id,
            'miniprogram' => $miniprogram,
            'data' => $data,
            'url' => $url,
        ];
        return parent::http_run($parm);
    }
}
