<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  ©2016-2021 All rights reserved.
 */
namespace Tpmission\Openwechat\OfficialAccount\Qrcode;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function created(array $parm = [])
    {
        parent::init('OfficialAccount\Qrcode');

        $qrcodeType = $parm['qrcodeType'] ?? '';
        $scene = $parm['scene'] ?? '';
        $expireSeconds = $parm['expireSeconds'] ?? 0;
        $message = $parm["message"]?? [];
        $put = $parm["put"]?? "";

        if (! in_array($qrcodeType, $this->qrcodeTypes)) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('请选择参数二位码类型');
        }

        if (! $scene) {
            throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('请设置参数二维码参数');
        }

        if ($qrcodeType === 'temporary') {
            if (!$expireSeconds) {
                throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('请设置参数二维码有效时间');
            }

            if($expireSeconds > 30*24*3600) {
                throw new \Tpmission\Openwechat\Exceptions\InvalidArgumentException('参数二维码有效时间不能大于30天');
            }
        }

        $parm = [
            'qrcodeType' => $qrcodeType,
            'scene' => $scene,
            'expireSeconds' => $expireSeconds,
            'message' => $message,
            'put' => $put
        ]
        return parent::http_run($parm);
    }
}
