<?php

declare(strict_types=1);
/**
 * This file is part of Tpmission.
 *
 * @link     https://www.tpmission.com
 * @document https://wiki.tpmission.com
 * @contact  group@tpmission.com
 * @license  https://github.com/hyperf/hyperf/blob/master/LICENSE
 */
namespace Tpmission\Openwechat\OfficialAccount\MsgPreg;

use Tpmission\Openwechat\Common\BaseClient;
use Tpmission\Openwechat\Common\SdkContainer;

/**
 * Class Client.
 */
class Client extends BaseClient
{
    protected $preg_types = [
        'scene', 'video', 'voice', 'img', 'shortvideo', 'subscribe', 'text',
    ];

    protected $preg_methods = ['EQUAL', 'LIKE'];

    public function __construct(SdkContainer $sdkContainer)
    {
        parent::__construct($sdkContainer);
        parent::init(__NAMESPACE__);
    }

    public function create(array $parm = [])
    {
        parent::init('OfficialAccount\MsgPreg');

        $msg_type = $parm['msg_type'] ?? '';
        $preg_type = $parm['preg_type'] ?? '';
        $preg_content = $parm['preg_content'] ?? '';
        $msg_id = $parm['msg_id'] ?? 0;
        $preg_method = $parm['preg_method'] ?? '';
        if (! in_array($msg_type, $this->msg_types)) {
            $this->Errs('消息类型参数错误');
        }
        if (! in_array($preg_type, $this->preg_types)) {
            $this->Errs('匹配类型参数错误');
        }
        if (in_array($preg_type, ['scene', 'text']) && ! $preg_content) {
            $this->Errs('匹配内容不能为空');
        }
        if ($preg_type === 'text' && ! in_array($preg_method, $this->preg_methods)) {
            $this->Errs('匹配方式错误');
        }
        if (! $msg_id) {
            $this->Errs('请选择回复消息id');
        }
        $parm = [
            'msg_type' => $msg_type,
            'preg_type' => $preg_type,
            'preg_content' => $preg_content,
            'msg_id' => $msg_id,
            'preg_method' => $preg_method,
        ];
        return parent::http_run($parm);
    }

    public function edit(array $parm = [])
    {
        parent::init('OfficialAccount\MsgPreg');

        $msg_type = $parm['msg_type'] ?? '';
        $preg_type = $parm['preg_type'] ?? '';
        $preg_content = $parm['preg_content'] ?? '';
        $msg_id = $parm['msg_id'] ?? 0;
        $preg_id = $parm['preg_id'] ?? 0;
        $preg_method = $parm['preg_method'] ?? '';
        if (! $preg_id) {
            $this->Errs('请选择要编辑匹配回复内容');
        }
        if (! in_array($msg_type, $this->msg_types)) {
            $this->Errs('消息类型参数错误');
        }
        if (! in_array($preg_type, $this->preg_types)) {
            $this->Errs('匹配类型参数错误');
        }
        if (in_array($preg_type, ['scene', 'text']) && ! $preg_content) {
            $this->Errs('匹配内容不能为空');
        }
        if ($preg_type === 'text' && ! in_array($preg_method, $this->preg_methods)) {
            $this->Errs('匹配方式错误');
        }
        if (! $msg_id) {
            $this->Errs('请选择回复消息id');
        }
        $parm = [
            'msg_type' => $msg_type,
            'preg_type' => $preg_type,
            'preg_content' => $preg_content,
            'msg_id' => $msg_id,
            'preg_method' => $preg_method,
            'preg_id' => $preg_id,
        ];
        return parent::http_run($parm);
    }

    public function delete(array $parm = [])
    {
        parent::init('OfficialAccount\MsgPregDel');

        $preg_id = $parm['preg_id'] ?? 0;

        if (! $preg_id) {
            $this->Errs('请选择要删除匹配内容');
        }
        $parm = [
            'preg_id' => $preg_id,
        ];
        return parent::http_run($parm);
    }
}
